unit uModelEngine;
interface
uses
OpenGL,omega,omega3d;
//===========================================//
//    "uSpriteEngine"   //
//    3D.   //
//  3D .  //
//  ,    . //
//   Frustum.                            //
//===========================================//
type
  CModel = class
  protected
  public
    ID                : Integer;
    X, Y, Z           : single;
    Alpha             : Byte;
    Texture           : PTexture;
    Kill              : Boolean;
    Model             : PStaticMesh;
    rot_y,rot_z,rot_x : single;
    otr               : boolean;
    Vbox              : tVertex3D;
    Fx                : integer;
    NModel            : boolean;
    Animated          : boolean;
    PlayAnim          : boolean;
    iFrame            : Integer;
    fFrame            : Single;
    AModel            : PFFanimMesh;
    sx,sy,sz          : single;
    constructor Create; virtual;
    procedure Freeing; virtual;

    procedure Draw;    virtual;
    procedure Process; virtual;
end;

type
  CmodelEngine = class
  protected
  public
    List     : array of CModel;
    DrawList : array of Integer;
    Count    : Integer;

    InvertSort : Boolean;

    function  CreateNew : CModel;
    function  AddNew : Integer;
    procedure Del( ID : Integer );



    procedure Draw;    virtual;
    procedure Process; virtual;
end;

var
  SEngine  : CModelEngine;
implementation
uses
ugame,uRes;


//----------------------------------------------------------------------------//
//------------------------------   M O D E L  -------------------------------//
//----------------------------------------------------------------------------//

constructor CModel.Create;
Begin
inherited;
X         := 0;
Y         := 0;
Z         := 0;
Alpha     := 255;
Kill      := FALSE;
Texture   := nil;
rot_y     := 0;
rot_z     := 0;
rot_x     := 0;
sX        := 1;
sY        := 1;
sZ        := 1;
otr       := true;
fx        := OF_TEXTURING or OF_CULL_FACE or OF_LIGHTING ;
nmodel    := true;
Animated  := false;
PlayAnim  := false;
End;

procedure CMODel.Freeing;
Begin
End;

procedure CModel.Draw;
Begin
if animated = true then
begin
set3dmode;
Cam3D_Set( Camera );
Obj_Begin( FX );
  Obj_Move( x, y, z );
  obj_rotatex( rot_x);
  obj_rotatey( rot_y);
  obj_rotatez( rot_z);
  Obj_BindTexture( Texture );
  FFAMesh_DrawSmooth( AModel, iFrame, fFrame );
Obj_End;
end else
begin
if Frustum_BoxIn( @frust, x, y,z, vbox.x, vbox.y,vbox.z) then
if NModel = true then
if otr = true then begin
set3dmode;
Cam3D_Set( Camera );
Obj_Begin( fx);
  Obj_Move( x, y, z );
  Obj_Scale ( sX, sY, sZ  );
  obj_rotatex( rot_x);
  obj_rotatey( rot_y);
  obj_rotatez( rot_z);
  Obj_BindTexture( Texture );
  SMesh_Draw( Model );
Obj_End;
end;
end;

End;

procedure CModel.Process;
Begin
if animated = true then
if playAnim = true then
begin
if fFrame < 1 Then
  fFrame := fFrame + 0.25
else
  begin
    fFrame := 0;
    if iFrame < AModel.FrameCount - 1 Then
    INC( iFrame )
    else
    iFrame := 0;
  end;
end;


End;

//----------------------------------------------------------------------------//
//------------------------  M O D E L    E N G I N E  ------------------------//
//----------------------------------------------------------------------------//

function CModelEngine.CreateNew : CModel;
Begin
INC( Count );

SetLength( List, Count );
SetLength( DrawList, Count );

List[ Count - 1 ]     := CModel.Create;
List[ Count - 1 ].ID  := Count - 1;
DrawList[ Count - 1 ] := List[ Count - 1 ].ID;
Result                := List[ Count - 1 ];
End;

function CmodelEngine.AddNew;
Begin
INC( Count );

SetLength( List, Count );
SetLength( DrawList, Count );

DrawList[ Count - 1 ] := Count - 1;
Result                := Count - 1;

End;

procedure CModelEngine.Del( ID : Integer );
  var
    i : Integer;
Begin
if Count = 0 Then exit;
DEC( Count );
List[ ID ].Freeing;
List[ ID ].Free;
for i := ID to Count - 1 do
  begin
    List[ i ]    := List[ i + 1 ];
    List[ i ].ID := List[ i ].ID - 1;
  end;
SetLength( List, Count );

SetLength( DrawList, Count );
for i := 0 to Count - 1 do
  DrawList[ i ] := List[ i ].ID;
End;



procedure CModelEngine.Draw;
  var
    i : Integer;
Begin
for i := 0 to Count - 1 do
  List[ DrawList[ i ] ].Draw;
End;

procedure CModelEngine.Process;
  var
    i : Integer;
Begin
i := 0;
while i <= Count - 1 do
  begin
    if List[ i ].Kill Then
      begin
        Del( List[ i ].ID );
        DEC( i );
      end else
        List[ i ].Process;
    INC( i );
  end;
End;

initialization
begin

// M O D E L   E N G I N E
SEngine       := CModelEngine.Create;
SEngine.Count := 0;

end;

end.
